/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import com.sun.opengl.util.Screenshot;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.util.Sort;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.ui.GfxItem;
import frc.emul.vectrex.ui.HeadlessDisplay;
import frc.emul.vectrex.ui.opengl.GLUtils;
import frc.emul.vectrex.ui.opengl.IJoglShader;
import frc.emul.vectrex.ui.opengl.IJoglShaderContext;
import frc.emul.vectrex.ui.opengl.IRenderer;
import frc.emul.vectrex.ui.opengl.JoglContext;
import frc.emul.vectrex.ui.opengl.JoglListenerShader;
import frc.emul.vectrex.ui.opengl.JoglListenerShaderOverlay;
import frc.emul.vectrex.ui.opengl.shader.ShaderNotSupportedException;
import frc.jogl.tools.FPSUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.ComponentEvents;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoglListenerBlur
implements IRenderer,
IJoglShaderContext,
GLEventListener,
PropertyChangeListener {
    private static boolean OVERLAY_SHADER = false;
    private final GLU glu = new GLU();
    public static boolean SORT_VECTORS_BY_BRIGHTNESS = true;
    private static final float SHIMMERING_DIVISOR = 350.0f;
    public static final boolean LOG_RESHAPE = false;
    public static final boolean BEAM_POSITION_NOAA = false;
    private int maxItemsDrawn = -1;
    private int drawableWidth;
    private int drawableHeight;
    private int viewportWidth;
    private int viewportHeight;
    private float viewportScaleX;
    private float viewportScaleY;
    private GLAutoDrawable drawable;
    private File screenShotAsked;
    private File screenShotTaken;
    public static final float PERSISTENCE = 0.25f;
    private int VECTOR_PERSISTENCE;
    private List<GfxItem>[] items;
    private JoglContext context;
    private final GfxItem beamPosition = GfxItem.newPoint(0.0f, 0.0f, 0);
    private float INITIAL_DISK_ANGLE = (float)(Math.random() * 360.0 - 180.0);
    private boolean ticksDriven;
    private boolean aaState;
    private boolean reverseState;
    private float lastPointSize = -1.0f;
    private float lastLineSize = -1.0f;
    private boolean resizingNeeded;
    private boolean shaderActive;
    private IJoglShader shader;
    private State state;

    public JoglListenerBlur(JoglContext joglContext) {
        this.setContext(joglContext);
    }

    private void setContext(JoglContext joglContext) {
        JoglContext joglContext2 = this.context;
        if (joglContext2 != null) {
            throw new UnsupportedOperationException("Context changing not supported yet!");
        }
        joglContext.addPropertyChangeListener(this);
        this.context = joglContext;
        this.state = State.NOT_STARTED;
        this.VECTOR_PERSISTENCE = joglContext.isPersistenceAllowed() ? joglContext.getPersistenceHistorySize() : 1;
        this.items = new List[this.VECTOR_PERSISTENCE];
        int n = this.VECTOR_PERSISTENCE;
        while (--n >= 0) {
            this.items[n] = new ArrayList<GfxItem>();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("SHADER_UPDATED".equals(string)) {
            IJoglShader iJoglShader = this.shader;
            if (iJoglShader != null) {
                iJoglShader.shaderSettingsChanged();
            }
        } else if ("FULL_VIEWPORT".equals(string) || "CHASSIS_ENABLED".equals(string)) {
            this.resizingNeeded = true;
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.drawable = gLAutoDrawable;
        if (this.state != State.NOT_STARTED) {
            System.out.println("* GLEventListener.init(Fast)");
            this.reinit(gLAutoDrawable.getGL(), this.glu);
        } else {
            System.out.println("* GLEventListener.init(Full)");
            this.init(gLAutoDrawable.getGL(), this.glu);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        String string;
        this.drawable = gLAutoDrawable;
        GL gL = gLAutoDrawable.getGL();
        if (this.resizingNeeded) {
            this.resizingNeeded = false;
            this.reshape(gLAutoDrawable.getGL(), this.glu, this.drawableWidth, this.drawableHeight);
        }
        this.updateStates(gL);
        this.render(gL, this.glu);
        if (this.screenShotAsked != null) {
            this.saveScreenShot((GLDrawable)gLAutoDrawable);
        }
        if (this.context.isFpsDrawn()) {
            FPSUtils.drawFPS(gL, this.glu, (GLDrawable)gLAutoDrawable);
        }
        if ((string = this.context.getDebugText()) != null) {
            FPSUtils.drawText(gL, this.glu, (GLDrawable)gLAutoDrawable, 5, -15, string, false);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.drawable = gLAutoDrawable;
        this.reshape(gLAutoDrawable.getGL(), this.glu, n3, n4);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        System.out.println("* GLEventListener.displayChanged()");
        this.drawable = gLAutoDrawable;
    }

    @Override
    public ComponentEvents getEventsSource() {
        return this.drawable;
    }

    @Override
    public int getDrawableHeight() {
        return this.drawableHeight;
    }

    @Override
    public int getDrawableWidth() {
        return this.drawableWidth;
    }

    @Override
    public int getViewportHeight() {
        return this.viewportHeight;
    }

    @Override
    public int getViewportWidth() {
        return this.viewportWidth;
    }

    @Override
    public JoglContext getContext() {
        return this.context;
    }

    private synchronized void reinit(GL gL, GLU gLU) {
        this.init(gL, gLU);
        this.forceAAState(gL, this.context.isAntiAliasEnabled());
        this.updatePrimitiveSizes(gL, true);
    }

    public synchronized void init(GL gL, GLU gLU) {
        gL.glHint(3154, 4354);
        gL.glHint(3153, 4354);
        gL.glDisable(3552);
        gL.glDisable(3553);
        gL.glDisable(32879);
        gL.glDisable(2896);
        gL.glDisable(2884);
        gL.glDisable(2929);
        gL.glDepthMask(false);
        gL.glEnable(3042);
        GLUtils.useAlphaBlending(gL);
        this.forceReverseVideoState(gL, this.reverseState);
    }

    public synchronized void reshape(GL gL, GLU gLU, int n, int n2) {
        boolean bl = this.context.isFullViewportActive();
        int n3 = 0;
        int n4 = 0;
        if (90 == this.context.getRotation() % 180) {
            float f = (float)n2 / (float)(n == 0 ? 1 : n);
            if (f < 0.8f) {
                n3 = (int)((float)n - (float)n2 / 0.8f);
                if (bl) {
                    gL.glViewport(0, 0, n, n2);
                    this.viewportScaleX = (float)(n - n3) / (float)n;
                    this.viewportScaleY = 1.0f;
                } else {
                    gL.glViewport(n3 >> 1, 0, n - n3, n2);
                }
            } else {
                n4 = (int)((float)n2 - (float)n * 0.8f);
                if (bl) {
                    gL.glViewport(0, 0, n, n2);
                    this.viewportScaleX = 1.0f;
                    this.viewportScaleY = (float)(n2 - n4) / (float)n2;
                } else {
                    gL.glViewport(0, n4 >> 1, n, n2 - n4);
                }
            }
        } else {
            float f = (float)n / (float)(n2 == 0 ? 1 : n2);
            if (f >= 0.8f) {
                n3 = (int)((float)n - (float)n2 * 0.8f);
                if (bl) {
                    gL.glViewport(0, 0, n, n2);
                    this.viewportScaleX = (float)(n - n3) / (float)n;
                    this.viewportScaleY = 1.0f;
                } else {
                    gL.glViewport(n3 >> 1, 0, n - n3, n2);
                }
            } else {
                n4 = (int)((float)n2 - (float)n / 0.8f);
                if (bl) {
                    gL.glViewport(0, 0, n, n2);
                    this.viewportScaleX = 1.0f;
                    this.viewportScaleY = (float)(n2 - n4) / (float)n2;
                } else {
                    gL.glViewport(0, n4 >> 1, n, n2 - n4);
                }
            }
        }
        this.drawableWidth = n;
        this.drawableHeight = n2;
        this.viewportWidth = n - (bl ? 0 : n3);
        this.viewportHeight = n2 - (bl ? 0 : n4);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gLU.gluOrtho2D(-1.0, 1.001, -1.0, 1.001);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        if (this.shader != null) {
            this.shader.windowSizeChanged(gL, this);
        }
    }

    public synchronized void render(GL gL, GLU gLU) {
        float f;
        float f2;
        JoglContext joglContext = this.context;
        boolean bl = this.reverseState;
        int[] nArray = joglContext.getGammaCorrectionTable();
        int n = joglContext.getRotation();
        float f3 = joglContext.getShininess(false);
        float f4 = joglContext.getShininess(true);
        boolean bl2 = joglContext.isFullViewportActive();
        boolean bl3 = joglContext.isAdditiveBlendingEnabled() && !bl;
        boolean bl4 = this.ticksDriven || joglContext.getHackSettings().isEnabled() && joglContext.getHackSettings().isInterlaced();
        int n2 = 0;
        switch (this.state) {
            case NOT_STARTED: {
                this.renderSplashScreen(gL, gLU, n, 0.0f);
                this.state = State.LOAD_TEXTURE;
                return;
            }
            case LOAD_TEXTURE: {
                joglContext.loadTextures(gL);
                this.state = State.INITIALISED;
                break;
            }
            case INITIALISED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
            }
        }
        if (joglContext.isWobblingEnabled()) {
            f2 = ((float)Math.random() - 0.5f) * joglContext.getWobblingFactor() / 350.0f;
            f = ((float)Math.random() - 0.5f) * joglContext.getWobblingFactor() / 350.0f;
        } else {
            f2 = 0.0f;
            f = 0.0f;
        }
        this.renderInit(gL, gLU);
        gL.glLoadIdentity();
        if (n != 0) {
            gL.glRotatef((float)n, 0.0f, 0.0f, 1.0f);
        }
        if (bl2) {
            gL.glScalef(this.viewportScaleX, this.viewportScaleY, 1.0f);
        }
        joglContext.preRender(gL);
        float f5 = 255.0f * joglContext.getBrightnessFactor();
        if (this.shader != null && joglContext.getGlowShader().attenuation) {
            f4 /= joglContext.getGlowShader().attenuationFactor;
        }
        do {
            int n3 = ++n2 == 1 && joglContext.isPersistenceEnabled() ? this.items.length : (bl4 ? 2 : 1);
            this.renderStartPass(gL, n2);
            while (--n3 >= 0) {
                float f6;
                int n4;
                GfxItem gfxItem;
                float f7;
                float f8 = f2;
                float f9 = f;
                if (n3 > 0) {
                    if (bl4 && n3 == 1) {
                        if (bl3) {
                            GLUtils.useAdditiveBlending(gL);
                        }
                        f7 = f3;
                    } else {
                        f9 = 0.0f;
                        f8 = 0.0f;
                        f7 = f4 * (0.25f - 0.25f * ((float)n3 / (float)this.items.length));
                    }
                } else {
                    if (bl3) {
                        GLUtils.useAdditiveBlending(gL);
                    }
                    f7 = f3;
                }
                int n5 = -1;
                List<GfxItem> list = this.items[n3];
                int n6 = this.getDrawnItemsCount(list);
                gL.glBegin(0);
                int n7 = 0;
                while (n7 < n6) {
                    gfxItem = list.get(n7);
                    if (gfxItem.isPoint()) {
                        n4 = nArray[gfxItem.brightness];
                        if (n4 != n5) {
                            f6 = f7 * ((float)n4 / f5);
                            if (f6 > 1.0f) {
                                f6 = 1.0f;
                            }
                            if (bl) {
                                f6 = 1.0f - f6;
                            }
                            gL.glColor3f(f6, f6, f6);
                        }
                        gL.glVertex2f(gfxItem.x0 + f8, gfxItem.y0 + f9);
                    }
                    ++n7;
                }
                gL.glEnd();
                gL.glBegin(1);
                n7 = 0;
                while (n7 < n6) {
                    gfxItem = list.get(n7);
                    if (!gfxItem.isPoint()) {
                        n4 = nArray[gfxItem.brightness];
                        if (n4 != n5) {
                            n5 = n4;
                            f6 = f7 * ((float)n4 / f5);
                            if (f6 > 1.0f) {
                                f6 = 1.0f;
                            }
                            if (bl) {
                                f6 = 1.0f - f6;
                            }
                            gL.glColor3f(f6, f6, f6);
                        }
                        gL.glVertex2f(gfxItem.x0 + f8, gfxItem.y0 + f9);
                        gL.glVertex2f(gfxItem.x1 + f8, gfxItem.y1 + f9);
                    }
                    ++n7;
                }
                gL.glEnd();
            }
            if (!bl3) continue;
            GLUtils.useAlphaBlending(gL);
        } while (this.renderEndPass(gL, n2));
        if (joglContext.isBeamPositionShown()) {
            joglContext.getBeamPositionColor().apply(gL);
            gL.glBegin(1);
            gL.glVertex2f(-20.0f, this.beamPosition.y0);
            gL.glVertex2f(20.0f, this.beamPosition.y0);
            gL.glVertex2f(this.beamPosition.x0, -20.0f);
            gL.glVertex2f(this.beamPosition.x0, 20.0f);
            gL.glEnd();
        }
        joglContext.postRender(gL);
        if (bl2) {
            gL.glScalef(1.0f / this.viewportScaleX, 1.0f / this.viewportScaleY, 1.0f);
        }
    }

    protected void renderInit(GL gL, GLU gLU) {
        boolean bl = true;
        boolean bl2 = this.context.isGlowShaderEnabled();
        if (bl2 != this.shaderActive) {
            if (this.context.isGlowShaderBlocked()) {
                this.shaderActive = bl2;
            } else {
                this.setGlowShaderActivated(bl2);
            }
        }
        if (this.shader != null) {
            if (this.shaderActive) {
                try {
                    bl = this.shader.renderStart(gL, this);
                }
                catch (ShaderNotSupportedException shaderNotSupportedException) {
                    System.out.println("*** The shader cannot run on this machine, it will be disabled (" + shaderNotSupportedException.getDetailedMessage() + ").");
                    this.shaderActive = false;
                }
                catch (Exception exception) {
                    System.out.println("*** Error during shader setup (this faulty shader will be disabled) :");
                    exception.printStackTrace(System.out);
                    System.out.println("*** .");
                    this.shaderActive = false;
                }
                if (!this.shaderActive) {
                    this.context.setGlowShaderBlocked(true);
                }
            }
            if (!this.shaderActive && this.shader != null) {
                System.out.println("Disabling shader...");
                try {
                    this.shader.shutdown(gL, this);
                }
                catch (Exception exception) {
                    System.err.println("*** Error while disabling shader :");
                    exception.printStackTrace(System.err);
                }
                this.shader = null;
            }
        }
        if (bl) {
            gL.glClear(16384);
        }
    }

    protected void renderStartPass(GL gL, int n) {
        if (this.shader != null) {
            this.shader.renderPassEntry(gL, this, n);
        }
    }

    protected boolean renderEndPass(GL gL, int n) {
        return this.shader == null ? false : this.shader.renderPassExit(gL, this, n);
    }

    private void renderSplashScreen(GL gL, GLU gLU, float f, float f2) {
        gL.glClear(16384);
        if (!this.context.hasTextureFiles()) {
            return;
        }
        this.renderDisk(gL, f, f2);
        gL.glLineWidth(1.5f);
        gL.glColor3f(0.9f, 1.0f, 0.9f);
        gL.glLoadIdentity();
        gL.glRotatef(f, 0.0f, 0.0f, 1.0f);
        gL.glTranslatef(-0.675f, 0.6f, 0.0f);
        gL.glScalef(0.1f, 0.1f, 1.0f);
        gL.glBegin(3);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
        gL.glTranslatef(2.5f, 0.0f, 0.0f);
        gL.glBegin(2);
        gL.glVertex2f(-0.7f, 1.0f);
        gL.glVertex2f(-1.0f, 0.7f);
        gL.glVertex2f(-1.0f, -0.7f);
        gL.glVertex2f(-0.7f, -1.0f);
        gL.glVertex2f(0.7f, -1.0f);
        gL.glVertex2f(1.0f, -0.7f);
        gL.glVertex2f(1.0f, 0.7f);
        gL.glVertex2f(0.7f, 1.0f);
        gL.glEnd();
        gL.glTranslatef(2.5f, 0.0f, 0.0f);
        gL.glBegin(3);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(-1.0f, 0.7f);
        gL.glVertex2f(-0.7f, 1.0f);
        gL.glVertex2f(0.7f, 1.0f);
        gL.glVertex2f(1.0f, 0.7f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
        gL.glBegin(3);
        gL.glVertex2f(-1.0f, 0.0f);
        gL.glVertex2f(1.0f, 0.0f);
        gL.glEnd();
        gL.glTranslatef(2.5f, 0.0f, 0.0f);
        gL.glBegin(2);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(0.7f, -1.0f);
        gL.glVertex2f(1.0f, -0.7f);
        gL.glVertex2f(1.0f, 0.7f);
        gL.glVertex2f(0.7f, 1.0f);
        gL.glEnd();
        gL.glTranslatef(1.75f, 0.0f, 0.0f);
        gL.glBegin(3);
        gL.glVertex2f(0.0f, -1.0f);
        gL.glVertex2f(0.0f, 1.0f);
        gL.glEnd();
        gL.glTranslatef(1.75f, 0.0f, 0.0f);
        gL.glBegin(3);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glEnd();
        gL.glTranslatef(2.5f, 0.0f, 0.0f);
        gL.glBegin(3);
        gL.glVertex2f(1.0f, 0.7f);
        gL.glVertex2f(0.7f, 1.0f);
        gL.glVertex2f(-0.7f, 1.0f);
        gL.glVertex2f(-1.0f, 0.7f);
        gL.glVertex2f(-1.0f, -0.7f);
        gL.glVertex2f(-0.7f, -1.0f);
        gL.glVertex2f(0.7f, -1.0f);
        gL.glVertex2f(1.0f, -0.7f);
        gL.glVertex2f(1.0f, 0.0f);
        gL.glVertex2f(0.0f, 0.0f);
        gL.glEnd();
        this.updatePrimitiveSizes(gL, true);
    }

    private void renderDisk(GL gL, float f, float f2) {
        gL.glLoadIdentity();
        gL.glRotatef(f, 0.0f, 0.0f, 1.0f);
        gL.glTranslatef(0.0f, -0.3f, 0.0f);
        gL.glScalef(0.55f, 0.45f, 1.0f);
        gL.glRotatef(f2 + this.INITIAL_DISK_ANGLE, 0.0f, 0.0f, 1.0f);
        gL.glColor4f(0.8f, 0.8f, 1.0f, 0.1f);
        gL.glLineWidth(4.0f);
        gL.glBegin(1);
        gL.glVertex2f(-0.55f, 0.75f);
        gL.glVertex2f(0.55f, 0.75f);
        gL.glVertex2f(-0.55f, 0.55f);
        gL.glVertex2f(0.55f, 0.55f);
        gL.glVertex2f(-0.55f, 0.35f);
        gL.glVertex2f(0.55f, 0.35f);
        gL.glVertex2f(-0.55f, 0.15f);
        gL.glVertex2f(0.55f, 0.15f);
        gL.glEnd();
        gL.glColor3f(0.8f, 0.8f, 1.0f);
        gL.glLineWidth(2.0f);
        gL.glBegin(2);
        gL.glVertex2f(-0.95f, 1.0f);
        gL.glVertex2f(-1.0f, 0.95f);
        gL.glVertex2f(-1.0f, -0.9f);
        gL.glVertex2f(-0.9f, -1.0f);
        gL.glVertex2f(0.95f, -1.0f);
        gL.glVertex2f(1.0f, -0.95f);
        gL.glVertex2f(1.0f, 0.95f);
        gL.glVertex2f(0.95f, 1.0f);
        gL.glEnd();
        gL.glLineWidth(1.5f);
        gL.glBegin(3);
        gL.glVertex2f(-0.75f, 1.0f);
        gL.glVertex2f(-0.75f, -0.1f);
        gL.glVertex2f(-0.7f, -0.15f);
        gL.glVertex2f(0.7f, -0.15f);
        gL.glVertex2f(0.75f, -0.1f);
        gL.glVertex2f(0.75f, 1.0f);
        gL.glEnd();
        gL.glBegin(3);
        gL.glVertex2f(-0.5f, -1.0f);
        gL.glVertex2f(-0.5f, -0.4f);
        gL.glVertex2f(-0.45f, -0.35f);
        gL.glVertex2f(0.7f, -0.35f);
        gL.glVertex2f(0.75f, -0.4f);
        gL.glVertex2f(0.75f, -1.0f);
        gL.glEnd();
        gL.glBegin(2);
        gL.glVertex2f(-0.38f, -0.92f);
        gL.glVertex2f(-0.15f, -0.92f);
        gL.glVertex2f(-0.15f, -0.43f);
        gL.glVertex2f(-0.38f, -0.43f);
        gL.glEnd();
        gL.glLineWidth(1.0f);
        gL.glBegin(2);
        gL.glVertex2f(0.825f, 0.8f);
        gL.glVertex2f(0.825f, 0.9f);
        gL.glVertex2f(0.925f, 0.9f);
        gL.glVertex2f(0.925f, 0.8f);
        gL.glEnd();
        float f3 = 0.0f;
        gL.glBegin(3);
        gL.glVertex2f(-0.5f - f3, -1.0f);
        gL.glVertex2f(-0.5f - f3, -0.4f + f3);
        gL.glVertex2f(-0.45f - f3, -0.35f + f3);
        gL.glVertex2f(0.45f + f3, -0.35f + f3);
        gL.glVertex2f(0.5f + f3, -0.4f + f3);
        gL.glVertex2f(0.5f + f3, -1.0f);
        gL.glEnd();
        gL.glTranslatef(0.875f, -0.875f, 0.0f);
        gL.glScalef(0.065f, 0.065f, 1.0f);
        gL.glColor4f(0.8f, 0.8f, 1.0f, 0.2f);
        gL.glBegin(2);
        gL.glVertex2f(-0.6f, 0.8f);
        gL.glVertex2f(-0.6f, 0.0f);
        gL.glVertex2f(-1.0f, 0.0f);
        gL.glVertex2f(-1.0f, 0.0f);
        gL.glVertex2f(0.0f, -1.0f);
        gL.glVertex2f(1.0f, 0.0f);
        gL.glVertex2f(1.0f, 0.0f);
        gL.glVertex2f(0.6f, 0.0f);
        gL.glVertex2f(0.6f, 0.8f);
        gL.glEnd();
    }

    public synchronized void setReadOnlyLines(List<GfxItem> list) {
        this.ticksDriven = false;
        this.items[0] = list == null ? Collections.EMPTY_LIST : list;
    }

    @Override
    public synchronized void setLines(List<GfxItem> list, boolean bl) {
        this.ticksDriven = bl;
        List<GfxItem> list2 = this.items[this.VECTOR_PERSISTENCE - 1];
        GfxItem.freeItems(list2);
        int n = this.VECTOR_PERSISTENCE;
        while (--n > 0) {
            this.items[n] = this.items[n - 1];
        }
        if (list != null) {
            if (SORT_VECTORS_BY_BRIGHTNESS) {
                this.sortByBrightness(list, list2);
            } else {
                n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    list2.add(list.get(n2));
                    ++n2;
                }
            }
            list.clear();
        }
        this.items[0] = list2;
    }

    @Override
    public synchronized void setBeamPosition(GfxItem gfxItem) {
        this.beamPosition.x0 = gfxItem.x0;
        this.beamPosition.y0 = gfxItem.y0;
    }

    @Override
    public synchronized boolean isInitialised() {
        return this.state == State.INITIALISED;
    }

    @Override
    public synchronized boolean isTakingScreenShot() {
        return this.screenShotTaken != null || this.screenShotAsked != null;
    }

    @Override
    public synchronized void takeScreenShot(File file) {
        if (!this.isTakingScreenShot()) {
            this.screenShotAsked = file;
        }
    }

    private void setGlowShaderActivated(boolean bl) {
        if (bl != this.shaderActive) {
            if (bl && this.shader == null) {
                this.shader = OVERLAY_SHADER ? new JoglListenerShaderOverlay() : new JoglListenerShader();
            }
            this.shaderActive = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScreenShot(GLDrawable gLDrawable) {
        JoglListenerBlur joglListenerBlur = this;
        synchronized (joglListenerBlur) {
            this.screenShotTaken = this.screenShotAsked;
            this.screenShotAsked = null;
        }
        int n = gLDrawable.getHeight();
        int n2 = gLDrawable.getWidth();
        try {
            try {
                Screenshot.writeToFile((File)this.screenShotTaken, (int)n2, (int)n);
                System.out.println("ScreenShot saved to \"" + this.screenShotTaken.getCanonicalPath() + "\"");
            }
            catch (Exception exception) {
                try {
                    System.err.println("Cannot save ScreenShot to \"" + this.screenShotTaken.getCanonicalPath() + "\", exception dumped :");
                }
                catch (Exception exception2) {}
                exception.printStackTrace(System.err);
                JOptionPane.showMessageDialog(null, "Could not save the screenshot!", "ParaJVE - ScreenShot error", 0);
                this.screenShotTaken = null;
            }
        }
        finally {
            this.screenShotTaken = null;
        }
    }

    private void updateStates(GL gL) {
        if (this.aaState != this.context.isAntiAliasEnabled()) {
            this.aaState = !this.aaState;
            this.forceAAState(gL, this.aaState);
        }
        if (this.reverseState != this.context.isReverseVideo()) {
            this.reverseState = !this.reverseState;
            this.forceReverseVideoState(gL, this.reverseState);
        }
        this.updatePrimitiveSizes(gL, false);
    }

    private void forceAAState(GL gL, boolean bl) {
        if (bl) {
            gL.glEnable(2832);
            gL.glEnable(2848);
        } else {
            gL.glDisable(2832);
            gL.glDisable(2848);
        }
    }

    private void forceReverseVideoState(GL gL, boolean bl) {
        if (bl) {
            gL.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            gL.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    private synchronized void updatePrimitiveSizes(GL gL, boolean bl) {
        float f = this.context.getPointsSize();
        if (bl || f != this.lastPointSize) {
            this.lastPointSize = f;
            gL.glPointSize(f);
        }
        f = this.context.getLinesSize();
        if (bl || f != this.lastLineSize) {
            this.lastLineSize = f;
            gL.glLineWidth(f);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sortByBrightness(List<GfxItem> var1_1, List<GfxItem> var2_2) {
        block3: {
            var3_3 = var1_1.size();
            var4_4 = Sort.mergeSort(var1_1);
            if (var1_1 == var2_2) ** GOTO lbl15
            if (!var2_2.isEmpty()) {
                GfxItem.freeItems(var2_2);
            }
            var5_5 = 0;
            while (var5_5 < var3_3) {
                var2_2.add((GfxItem)var4_4[var5_5]);
                ++var5_5;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var1_1.set(var3_3, (GfxItem)var4_4[var3_3]);
lbl15:
                // 2 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    @Override
    public IPersistentSection getSection() {
        return PersistentSection.DISP_BUFF_ACTIVE;
    }

    @Override
    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        HeadlessDisplay.store(iPersistenceWriter, this.items[0]);
    }

    @Override
    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        HeadlessDisplay.load(iPersistenceReader, this.items[0]);
        this.sortByBrightness(this.items[0], this.items[0]);
        int n = this.items.length;
        while (n-- > 1) {
            GfxItem.freeItems(this.items[n]);
        }
    }

    private int getDrawnItemsCount(List<GfxItem> list) {
        int n = list.size();
        return this.maxItemsDrawn < 0 ? n : Math.min(n, this.maxItemsDrawn);
    }

    public int getMaxItemsDrawn() {
        return this.maxItemsDrawn;
    }

    public void setMaxItemsDrawn(int n) {
        this.maxItemsDrawn = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_STARTED,
        LOAD_TEXTURE,
        INITIALISED;

    }
}

